#include "grapplinghook.h"

GrapplingHook::GrapplingHook(Object *parent, bool *trigger, Direction *direction, float offset, float force, Atom *hook) : Roster(parent) {
	this->direction = direction;
	this->trigger = trigger;
	this->offset = offset;
	this->force = force;
	this->hook = hook;
	delay = 0;
	last_atom = NULL;
	last_link = NULL;
	head = NULL;
}

void GrapplingHook::removeAtom(Atom *a) {
	Roster::removeAtom(a);

	if(a == hook)
		delete this;

	if(a == head)
		head = NULL;
}

void GrapplingHook::removeLink(Link *l) {
	Roster::removeLink(l);
	if(l == last_link) {
		last_link = NULL;
	}
}

bool GrapplingHook::allowRepulse(Atom *a, Atom *b) {	
	if(b->in(parent)) return false;
	else return Roster::allowRepulse(a, b);
}

void GrapplingHook::onRepulse(Atom *a, Atom *b, float force) {
	Roster::onRepulse(a, b, force);

	const float lbp = 0.2f;
	const float ubp = 2.5f;
	const float k = 0.80f;

	if(a == head) {
		Link *l = new Link(head, b, -1.0f, lbp - 0.5f, ubp + 3.0f, k);
		addLink(l);
		l->draw = false;

		head = NULL;
	}
}

void GrapplingHook::stepFunc() {
	float dx, dy;
	const float lbp = 0.2f;
	const float ubp = 2.5f;
	const float k = 0.80f;

	Roster::stepFunc();

	if(*trigger && delay < 0) {
		if(last_link) {
			delete last_link;
			delay = 10;
		}
		else {
			if(last_atom) {

				dx = hook->x - last_atom->x;
				dy = hook->y - last_atom->y;

				if(dx * dx + dy * dy > 800.0f) {
					direction->calc();

					Atom *a = new Atom(direction->x - direction->dx * offset, direction->y - direction->dy * offset, 1.0f, direction->dx * force + direction->ix, direction->dy * force + direction->iy, 0);
					addAtom(a);

					//if(last_link)
					//	delete last_link;

					dx = a->x - last_atom->x;
					dy = a->y - last_atom->y;
					if(dx * dx + dy * dy < 800) {
						Link *l = new Link(a, last_atom, -1.0f, lbp, ubp, k);
						addLink(l);
						l->draw = false;
					}
					else
						head = a;

					//last_link = addLink(new Link(a, hook));

					last_atom = a;
				}
			}
			else {
				direction->calc();

				Atom *a = new Atom(direction->x - direction->dx * offset, direction->y - direction->dy * offset, 1.0f, direction->dx * force + direction->ix, direction->dy * force + direction->iy, 1);
				addAtom(a);

				last_atom = a;
				head = a;
			}
			//a->interpolate = true;
		}
	}
	else if(last_atom) {
		Link *l = new Link(last_atom, hook, -1.0f, lbp, ubp, k);
		last_link = placeLink(l);
		l->draw = false;
		last_atom = NULL;
	}
	else
		delay--;
}

void GrapplingHook::draw() {
	Link *l;
	links.begin();
	glColor4f(0.5f, 0.5f, 0.5f, 1.0f);
	glLineWidth(2.0f);
	glBegin(GL_LINES);
		while(l = links.get()) {
			glVertex3f(l->a->x, l->a->y, 0.2f);
			glVertex3f(l->b->x, l->b->y, 0.2f);
		}
	glEnd();
	
	Roster::draw();
}